/*
 * Decompiled with CFR 0.152.
 */
package br.com.mrzsolucoes.main;

import br.com.mrzsolucoes.newkits.KitsCommand;
import br.com.mrzsolucoes.utils.FundationTools;
import java.io.File;
import java.io.IOException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public static Main main;
    public FileConfiguration kitsConfig;
    public FileConfiguration delaysConfig;
    public FileConfiguration msgConfig;
    public static String prefix;

    static {
        prefix = "";
    }

    public void onEnable() {
        main = this;
        this.kitsConfig = this.getConfiguration("kits.yml");
        this.kitsConfig.options().copyDefaults(true);
        this.saveKitsConfig();
        this.delaysConfig = this.getConfiguration("kitsdelay.yml");
        this.delaysConfig.options().copyDefaults(true);
        this.msgConfig = this.getConfiguration("mensagens.yml");
        this.msgConfig.options().copyDefaults(true);
        this.saveMsgConfig();
        this.saveDelaysConfig();
        this.saveKitsConfig();
        FundationTools.onMsg();
        this.registerCommands();
        this.registerEvents();
        prefix = this.msgConfig.getString("Prefix").replace("&", "\u00a7");
    }

    public void onDisable() {
        FundationTools.offMsg();
        this.saveDelaysConfig();
    }

    private void registerCommands() {
        this.getCommand("kit").setExecutor((CommandExecutor)new KitsCommand());
    }

    private void registerEvents() {
    }

    private FileConfiguration getConfiguration(String filename) {
        File file = new File(this.getDataFolder(), filename);
        if (!file.exists()) {
            this.saveResource(filename, false);
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    private void saveKitsConfig() {
        File kitsFile = new File(this.getDataFolder(), "kits.yml");
        try {
            this.kitsConfig.save(kitsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Nfoi posssalvar a configurade kits: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void saveMsgConfig() {
        File msgFile = new File(this.getDataFolder(), "mensagens.yml");
        try {
            this.msgConfig.save(msgFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Nfoi possivel a configurade Mensagens: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void saveDelaysConfig() {
        File delaysFile = new File(this.getDataFolder(), "kitsdelay.yml");
        try {
            this.delaysConfig.save(delaysFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Nfoi posssalvar a configurade Warps: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

