/*
 * Decompiled with CFR 0.152.
 */
package br.com.mrzsolucoes.newkits;

import br.com.mrzsolucoes.main.Main;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class KitsManager {
    public static Main pl = Main.main;

    public static void giveItens(Player player, String kitName) {
        List items = KitsManager.pl.kitsConfig.getList("kits." + kitName + ".items");
        for (Object itemObj : items) {
            if (!(itemObj instanceof Map)) continue;
            Map item = (Map)itemObj;
            ItemStack stack = KitsManager.createItemStack(item, player);
            if (stack != null) {
                player.getInventory().addItem(new ItemStack[]{stack});
                continue;
            }
            player.sendMessage("Um item no kit " + kitName + " esta mal configurado.");
        }
        player.sendMessage("Voce resgatou o kit " + kitName + ".");
    }

    private static ItemStack createItemStack(Map<?, ?> itemData, Player p) {
        Material type = Material.getMaterial((String)((String)itemData.get("type")));
        if (type == null) {
            return null;
        }
        String name = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)itemData.get("name")));
        List lore = (List)itemData.get("lore");
        int amount = itemData.containsKey("amount") ? (Integer)itemData.get("amount") : 1;
        ItemStack stack = new ItemStack(type, amount);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(name);
        if (lore != null) {
            List coloredLore = lore.stream().map(line -> {
                String replacedLine = line.replace("%jogador%", p.getName());
                return ChatColor.translateAlternateColorCodes((char)'&', (String)replacedLine);
            }).collect(Collectors.toList());
            meta.setLore(coloredLore);
        }
        stack.setItemMeta(meta);
        if (itemData.containsKey("enchants")) {
            Map enchants = (Map)itemData.get("enchants");
            for (Map.Entry entry : enchants.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof Integer)) continue;
                String enchantName = (String)entry.getKey();
                Enchantment enchantment = Enchantment.getByName((String)(enchantName = KitsManager.converterEncantos(enchantName)).toUpperCase());
                if (enchantment != null) {
                    stack.addUnsafeEnchantment(enchantment, ((Integer)entry.getValue()).intValue());
                    continue;
                }
                Bukkit.getLogger().warning("Encantamento invalido: " + enchantName);
            }
        }
        return stack;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String converterEncantos(String e) {
        switch (e = e.toLowerCase()) {
            case "inquebravel": {
                return "durability";
            }
            case "espinhos": {
                return "thorns";
            }
            case "afiada": {
                return "damage_all";
            }
            case "julgamento": {
                return "damage_undead";
            }
            case "infinidade": {
                return "arrow_infinite";
            }
            case "protecao": {
                return "protection_environmental";
            }
            case "ruinas": {
                return "damage_arthropods";
            }
            case "projeteis": {
                return "protection_projectile";
            }
            case "respiracao": {
                return "oxygen";
            }
            case "fortuna": {
                return "loot_bonus_blocks";
            }
            case "pilhagem": {
                return "loot_bonus_mobs";
            }
            case "repulsao": {
                return "knockback";
            }
            case "protecao contra fogo": {
                return "protection_fire";
            }
            case "fogo": {
                return "protection_fire";
            }
            case "pena": {
                return "protection_fall";
            }
            case "chama": {
                return "arrow_fire";
            }
            case "afinidade": {
                return "water_worker";
            }
            case "forca": {
                return "arrow_damage";
            }
            case "toque": {
                return "silk_touch";
            }
            case "afinidade aquatica": {
                return "water_worker";
            }
            case "explosoes": {
                return "protection_explosions";
            }
            case "eficiencia": {
                return "dig_speed";
            }
            case "remendo": {
                return "mending";
            }
            case "impacto": {
                return "arrow_knockback";
            }
            case "flamejante": {
                return "fire_aspect";
            }
        }
        return e;
    }
}

