/*
 * Decompiled with CFR 0.152.
 */
package br.com.mrzplugins.controller;

import br.com.mrzplugins.controller.ControllerTeleports;
import br.com.mrzplugins.controller.CreateArea;
import br.com.mrzplugins.controller.EventController;
import br.com.mrzplugins.controller.ScoreboardManager;
import br.com.mrzplugins.utils.VaultAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ControllerArena {
    private static JavaPlugin plugin;
    public static boolean rolando;
    public static boolean trancado;
    public static int premio;
    public static ArrayList<String> participantes;
    public static Location loc1;
    public static Location loc2;
    public static int contador;

    static {
        rolando = false;
        trancado = false;
        premio = 0;
        participantes = new ArrayList();
        loc1 = null;
        loc2 = null;
    }

    public ControllerArena(JavaPlugin plugin) {
        ControllerArena.plugin = plugin;
    }

    public void iniciarRunner() {
        if (!rolando) {
            Bukkit.getLogger().info("\u00a7f[\u00a78Zombie\u00a7cDead\u00a7f]\u00a7c Sem eventos no momento.");
            return;
        }
        if (participantes.size() < 2) {
            Bukkit.broadcastMessage((String)"");
            Bukkit.broadcastMessage((String)"\u00a7aEvento \u00a7bZombieDead \u00a7aCancelado");
            Bukkit.broadcastMessage((String)"\u00a7a\u00c9 necessario ao menos 2 participantes");
            rolando = false;
            trancado = false;
            participantes.clear();
            CreateArea.blocks.clear();
            EventController.contador.clear();
            return;
        }
        contador = plugin.getConfig().getInt("Tempo");
        new BukkitRunnable(){

            public void run() {
                if (participantes.isEmpty()) {
                    Bukkit.broadcastMessage((String)"");
                    Bukkit.broadcastMessage((String)"\u00a7aEvento \u00a7bZombieDead \u00a7aCancelado");
                    Bukkit.broadcastMessage((String)"\u00a7aTodos os participantes foram eliminados!!");
                    rolando = false;
                    trancado = false;
                    participantes.clear();
                    CreateArea.blocks.clear();
                    EventController.contador.clear();
                    this.cancel();
                    return;
                }
                ControllerArena.onSpawnZombie();
                ScoreboardManager.updateAll(contador, participantes.size());
                if (--contador == 0) {
                    if (EventController.contador.isEmpty()) {
                        Bukkit.broadcastMessage((String)"");
                        Bukkit.broadcastMessage((String)"\u00a7aEvento \u00a7bZombieDead \u00a7aCancelado");
                        Bukkit.broadcastMessage((String)"\u00a7aTodos os participantes foram eliminados!!");
                        rolando = false;
                        trancado = false;
                        participantes.clear();
                        CreateArea.blocks.clear();
                        EventController.contador.clear();
                        this.cancel();
                        ScoreboardManager.clearAllScoreboards();
                    } else {
                        Map.Entry vencedor = Collections.max(EventController.contador.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
                        String nomeVencedor = (String)vencedor.getKey();
                        int pontosVencedor = (Integer)vencedor.getValue();
                        Player p1 = Bukkit.getPlayer((String)nomeVencedor);
                        if (p1 == null || !p1.isOnline()) {
                            Bukkit.broadcastMessage((String)"");
                            Bukkit.broadcastMessage((String)"\u00a7aEvento \u00a7bZombieDead \u00a7aFinalizado");
                            Bukkit.broadcastMessage((String)"\u00a7cO jogador vencedor saiu do servidor, ningu\u00e9m venceu!");
                            rolando = false;
                            trancado = false;
                            participantes.clear();
                            CreateArea.blocks.clear();
                            EventController.contador.clear();
                            this.cancel();
                            ScoreboardManager.clearAllScoreboards();
                        } else if (pontosVencedor <= 0) {
                            Bukkit.broadcastMessage((String)"");
                            Bukkit.broadcastMessage((String)"\u00a7a\u00a7lO vencedor sobreviveu");
                            ControllerArena.onWinner(p1, 0);
                        } else {
                            ControllerArena.onWinner(p1, pontosVencedor);
                            ScoreboardManager.clearAllScoreboards();
                        }
                    }
                    participantes.clear();
                    CreateArea.blocks.clear();
                    EventController.contador.clear();
                    rolando = false;
                    trancado = false;
                    ScoreboardManager.clearAllScoreboards();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 100L);
    }

    public static void onSpawnZombie() {
        Map<Location, Material> blocks = CreateArea.blocks;
        if (blocks.isEmpty()) {
            Bukkit.getLogger().info("\u00a7f[\u00a78Zombie\u00a7cDead\u00a7f] Nenhum local dispon\u00edvel");
            return;
        }
        int size = blocks.size();
        ArrayList<Location> locations = new ArrayList<Location>(blocks.keySet());
        int randomIndex = new Random().nextInt(size);
        Location loc = (Location)locations.get(randomIndex);
        World world = loc.getWorld();
        String mundo = plugin.getConfig().getString("world");
        if (!loc.getWorld().getName().equalsIgnoreCase(mundo)) {
            return;
        }
        if (world != null) {
            world.spawn(loc.add(0.5, 1.0, 0.5), Zombie.class);
        }
        blocks.remove(loc);
    }

    public static void onWinner(Player p, int pontosVencedor) {
        if (participantes.size() > 1) {
            int i = 0;
            while (i > participantes.size()) {
                String playerName = participantes.get(i);
                Player p1 = Bukkit.getPlayer((String)playerName);
                ControllerTeleports.onExit(p1);
                ++i;
            }
        }
        Bukkit.broadcastMessage((String)"");
        Bukkit.broadcastMessage((String)"\u00a7aEvento \u00a7bZombieDead \u00a7aFinalizado");
        Bukkit.broadcastMessage((String)("\u00a7aParab\u00e9ns ao ganhador(a): \u00a7b" + p.getName()));
        Bukkit.broadcastMessage((String)("\u00a7aO jogador(a) \u00a7b" + p.getName() + " \u00a7aMatou\u00a7b " + pontosVencedor + "\u00a7a Zumbis"));
        Bukkit.broadcastMessage((String)("\u00a7b" + p.getName() + " \u00a7aganhou o pr\u00eamio de: \u00a7b" + premio + "$"));
        VaultAPI.getEconomy().depositPlayer(p.getName(), (double)premio);
        ScoreboardManager.clearAllScoreboards();
    }
}

