/*
 * Decompiled with CFR 0.152.
 */
package br.com.mrzplugins.controller;

import br.com.mrzplugins.controller.ControllerArena;
import br.com.mrzplugins.controller.EventController;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class ScoreboardManager {
    public static void updateAll(int tempo, int participantes) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!ControllerArena.participantes.contains(p.getName())) {
                return;
            }
            ScoreboardManager.update(p, tempo, participantes);
        }
    }

    public static void update(Player p, int tempo, int participantes) {
        if (!ControllerArena.participantes.contains(p.getName())) {
            return;
        }
        ScoreboardManager.createBoard(p, tempo, participantes);
    }

    private static void createBoard(Player p, int tempo, int participantes) {
        Scoreboard board = Bukkit.getScoreboardManager().getNewScoreboard();
        Objective obj = board.registerNewObjective("zdead", "dummy");
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        obj.setDisplayName("\u00a7c\u00a7lZombie\u00a7f\u00a7lDead");
        int minutos = tempo / 60;
        int segundos = tempo % 60;
        String tempoFormatado = String.format("%02d:%02d", minutos, segundos);
        obj.getScore("\u00a7fTempo restante: \u00a7a" + tempoFormatado + "\u00a7k").setScore(3);
        obj.getScore("\u00a7fParticipantes: \u00a7b" + participantes + "\u00a7k").setScore(2);
        if (EventController.contador.isEmpty()) {
            obj.getScore("\u00a7fMaior Pontua\u00e7\u00e3o: \u00a7b Ningu\u00e9m pontuou\u00a7r").setScore(1);
        } else {
            Map.Entry vencedor = Collections.max(EventController.contador.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
            Player p1 = Bukkit.getPlayer((String)((String)vencedor.getKey()));
            int pontosVencedor = (Integer)vencedor.getValue();
            obj.getScore("\u00a7fMaior Pontua\u00e7\u00e3o: \u00a7b" + (p1 != null ? p1.getName() : (String)vencedor.getKey()) + "\u00a7k").setScore(1);
        }
        p.setScoreboard(board);
    }

    public static void clearScoreboard(Player p) {
        p.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
    }

    public static void clearAllScoreboards() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            ScoreboardManager.clearScoreboard(p);
        }
    }
}

