/*
 * Decompiled with CFR 0.152.
 */
package br.com.mrzplugins.controller;

import br.com.mrzplugins.controller.EventController;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ScoreboardManager2 {
    public static void updateAll(int tempo, int participantes) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            ScoreboardManager2.update(p, tempo, participantes);
        }
    }

    public static void update(Player p, int tempo, int participantes) {
        ScoreboardManager2.createBoard(p, tempo, participantes);
    }

    private static void createBoard(Player p, int tempo, int participantes) {
        Scoreboard board = Bukkit.getScoreboardManager().getNewScoreboard();
        Objective obj = board.registerNewObjective("zdead", "dummy");
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        obj.setDisplayName("\u00a7c\u00a7lZombie\u00a7f\u00a7lDead");
        int minutos = tempo / 60;
        int segundos = tempo % 60;
        String tempoFormatado = String.format("%02d:%02d", minutos, segundos);
        String entryTempo = "\u00a7a";
        String entryParticipantes = "\u00a7b";
        String entryPontuador = "\u00a7c";
        obj.getScore(entryTempo).setScore(3);
        obj.getScore(entryParticipantes).setScore(2);
        obj.getScore(entryPontuador).setScore(1);
        Team tempoTeam = board.registerNewTeam("tempoTeam");
        tempoTeam.addEntry(entryTempo);
        tempoTeam.setPrefix("\u00a7fTempo restante: \u00a7a" + tempoFormatado);
        Team participantesTeam = board.registerNewTeam("participantesTeam");
        participantesTeam.addEntry(entryParticipantes);
        participantesTeam.setPrefix("\u00a7fParticipantes: \u00a7b" + participantes);
        Team pontuadorTeam = board.registerNewTeam("pontuadorTeam");
        pontuadorTeam.addEntry(entryPontuador);
        if (EventController.contador.isEmpty()) {
            pontuadorTeam.setPrefix("\u00a7fMaior Pontua\u00e7\u00e3o: \u00a7bNingu\u00e9m pontuou");
        } else {
            Map.Entry vencedor = Collections.max(EventController.contador.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
            String nome = Bukkit.getPlayer((String)((String)vencedor.getKey())) != null ? Bukkit.getPlayer((String)((String)vencedor.getKey())).getName() : (String)vencedor.getKey();
            pontuadorTeam.setPrefix("\u00a7fMaior Pontua\u00e7\u00e3o: \u00a7b" + nome);
        }
        p.setScoreboard(board);
    }

    public static void clearScoreboard(Player p) {
        p.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
    }

    public static void clearAllScoreboards() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            ScoreboardManager2.clearScoreboard(p);
        }
    }
}

