/*
 * Decompiled with CFR 0.152.
 */
package br.com.mrzplugins.utils;

import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultAPI {
    private static Permission permission = null;
    private static Economy economy = null;
    private static Chat chat = null;

    static {
        if (VaultAPI.hasVault()) {
            VaultAPI.setupVault();
        }
    }

    public static Permission getPermission() {
        return permission;
    }

    public static Chat getChat() {
        return chat;
    }

    public static Economy getEconomy() {
        return economy;
    }

    public static boolean hasVault() {
        return Bukkit.getPluginManager().getPlugin("Vault") != null;
    }

    public static boolean hasEconomy() {
        return economy != null;
    }

    public static boolean hasChat() {
        return chat != null;
    }

    public static boolean hasPermission() {
        return permission != null;
    }

    private static boolean setupChat() {
        RegisteredServiceProvider chatProvider = Bukkit.getServer().getServicesManager().getRegistration(Chat.class);
        if (chatProvider != null) {
            chat = (Chat)chatProvider.getProvider();
        }
        return chat != null;
    }

    private static boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            economy = (Economy)economyProvider.getProvider();
        }
        return economy != null;
    }

    private static boolean setupPermissions() {
        RegisteredServiceProvider permissionProvider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null) {
            permission = (Permission)permissionProvider.getProvider();
        }
        return permission != null;
    }

    public static void setupVault() {
        VaultAPI.setupEconomy();
        VaultAPI.setupChat();
        VaultAPI.setupPermissions();
    }
}

